# Digital Marketplace (PHP + MySQL) — LEGAL TEMPLATE

A clean, modern **digital goods marketplace** with wallet, orders, admin panel, and support tickets. 
Built with **PHP 8.1+**, **MySQL**, **PDO**, **Tailwind (CDN)**, and **vanilla JS**.

> ⚠️ This template is for lawful use only (e.g., selling your own scripts, licenses, graphics). 
> Do **NOT** use for illicit goods. Add KYC/AML, ToS, logs, and rate limits before going live.

## Features
- Auth: Signup/Login/Logout with bcrypt.
- Security: CSRF tokens, prepared statements, role-based access.
- Wallet: Manual deposit requests + mock webhook handler (replace with Stripe/Razorpay/etc.).
- Products: Create, list, filter, purchase, instant delivery of digital content (stored in DB).
- Orders: Purchase history, detail view.
- Tickets: User support tickets, admin replies & status.
- Admin: Stats, users, deposits approve/reject, products CRUD, orders, tickets.
- UI: Tailwind dark/light, modern layout, mobile-first.

## Quick Start
1. Create DB and import `database/schema.sql`.
2. Copy `config.sample.php` to `config.php` and set DB creds + site URL.
3. Serve `public/` as document root (Apache/Nginx). PHP 8.1+ required.
4. Create an admin: register a normal user, then in DB set `users.role = 'admin'` for that user.
5. Payment: use `Manual Deposit` flow to test. For real gateways, wire up `/webhooks/mock-gateway.php` to your provider.
6. Optional: set a cron to run `php cli/auto_tasks.php` for housekeeping.

## Folders
- `public/` — public entrypoints & routes
- `app/` — core libs (auth, db, csrf, helpers)
- `views/` — layouts & components
- `modules/` — domain modules (products, wallet, orders, tickets)
- `admin/` — admin panel routes
- `database/` — schema & seeds
- `webhooks/` — example webhook endpoint
- `cli/` — housekeeping scripts

## License
MIT — no warranty. You are responsible for compliance and lawful use.
