<?php require __DIR__.'/_guard.php'; $pdo=db();
if(isset($_GET['approve'])){
  $id=(int)$_GET['approve'];
  $pdo->beginTransaction();
  $d=$pdo->prepare('SELECT * FROM deposits WHERE id=? FOR UPDATE'); $d->execute([$id]); $dep=$d->fetch();
  if($dep && $dep['status']==='pending'){
    $pdo->prepare('UPDATE deposits SET status="approved", updated_at=NOW() WHERE id=?')->execute([$id]);
    $pdo->prepare('UPDATE users SET balance_cents=balance_cents+? WHERE id=?')->execute([$dep['amount_cents'],$dep['user_id']]);
  }
  $pdo->commit();
  redirect('/admin/deposits.php');
}
if(isset($_GET['reject'])){
  $id=(int)$_GET['reject'];
  $pdo->prepare('UPDATE deposits SET status="rejected", updated_at=NOW() WHERE id=?')->execute([$id]);
  redirect('/admin/deposits.php');
}
$rows=$pdo->query('SELECT d.*, u.username FROM deposits d JOIN users u ON u.id=d.user_id ORDER BY d.id DESC')->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Deposits</h1>
<table class="w-full text-sm">
<tr class="text-left opacity-70"><th>ID</th><th>User</th><th>Amount</th><th>Method</th><th>Status</th><th>Ref</th><th>Actions</th></tr>
<?php foreach($rows as $r): ?>
<tr class="border-b">
  <td><?= (int)$r['id'] ?></td>
  <td><?= e($r['username']) ?></td>
  <td>₹ <?= e(cents($r['amount_cents'])) ?></td>
  <td><?= e($r['method']) ?></td>
  <td><?= e($r['status']) ?></td>
  <td><?= e($r['reference']) ?></td>
  <td>
    <?php if($r['status']==='pending'): ?>
      <a class="underline" href="/admin/deposits.php?approve=<?= (int)$r['id'] ?>">Approve</a> •
      <a class="underline" href="/admin/deposits.php?reject=<?= (int)$r['id'] ?>">Reject</a>
    <?php endif; ?>
  </td>
</tr>
<?php endforeach; ?>
</table>
<?php $content=ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
