<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/auth.php';
require_admin();
$pdo = db();
$stats = [
  'users' => $pdo->query('SELECT COUNT(*) c FROM users')->fetch()['c'],
  'products' => $pdo->query('SELECT COUNT(*) c FROM products')->fetch()['c'],
  'orders' => $pdo->query('SELECT COUNT(*) c FROM orders')->fetch()['c'],
  'pending_deposits' => $pdo->query("SELECT COUNT(*) c FROM deposits WHERE status='pending'")->fetch()['c'],
  'open_tickets' => $pdo->query("SELECT COUNT(*) c FROM tickets WHERE status='open'")->fetch()['c'],
];
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Admin Dashboard</h1>
<div class="grid md:grid-cols-3 gap-4">
  <?php foreach($stats as $k=>$v): ?>
    <div class="p-4 rounded-2xl border bg-white/50 dark:bg-slate-800/50">
      <div class="text-xs uppercase opacity-70"><?= e(str_replace('_',' ', $k)) ?></div>
      <div class="text-3xl font-bold"><?= (int)$v ?></div>
    </div>
  <?php endforeach; ?>
</div>
<div class="mt-6 flex gap-3 text-sm">
  <a class="px-3 py-2 rounded-xl border" href="/admin/products.php">Products</a>
  <a class="px-3 py-2 rounded-xl border" href="/admin/deposits.php">Deposits</a>
  <a class="px-3 py-2 rounded-xl border" href="/admin/users.php">Users</a>
  <a class="px-3 py-2 rounded-xl border" href="/admin/tickets.php">Tickets</a>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
