<?php require __DIR__.'/_guard.php'; $pdo=db();
if($_SERVER['REQUEST_METHOD']==='POST'){
  $title=trim($_POST['title']??''); $price=(int)round(floatval($_POST['price']??'0')*100);
  $brand=trim($_POST['brand']??''); $country=trim($_POST['country']??''); $stock=(int)($_POST['stock']??0);
  $delivery=trim($_POST['delivery']??'');
  $st=$pdo->prepare('INSERT INTO products (title,country,bin_prefix,brand,price_cents,stock,delivery_text) VALUES (?,?,?,?,?,?,?)');
  $st->execute([$title,$country,'',$brand,$price,$stock,$delivery]);
}
$rows=$pdo->query('SELECT * FROM products ORDER BY id DESC')->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Products</h1>
<form method="post" class="grid md:grid-cols-2 gap-3 rounded-2xl border p-4 mb-6">
  <input class="border p-2 rounded" name="title" placeholder="Title" required>
  <input class="border p-2 rounded" name="brand" placeholder="Type (Key, Book, License)">
  <input class="border p-2 rounded" name="country" placeholder="Country (optional)">
  <input class="border p-2 rounded" name="price" placeholder="Price (₹)" required>
  <input class="border p-2 rounded" name="stock" placeholder="Stock" required>
  <textarea class="border p-2 rounded col-span-full" name="delivery" placeholder="Delivery content (what buyer receives)"></textarea>
  <button class="px-4 py-2 rounded-xl bg-slate-900 text-white col-span-full">Add Product</button>
</form>
<table class="w-full text-sm">
  <tr class="text-left opacity-70"><th>ID</th><th>Title</th><th>Price</th><th>Stock</th><th></th></tr>
  <?php foreach($rows as $r): ?>
    <tr class="border-b">
      <td><?= (int)$r['id'] ?></td>
      <td><?= e($r['title']) ?></td>
      <td>₹ <?= e(cents($r['price_cents'])) ?></td>
      <td><?= (int)$r['stock'] ?></td>
      <td>
        <a class="underline" href="/admin/product_toggle.php?id=<?= (int)$r['id'] ?>">
          <?= $r['is_active']?'Disable':'Enable' ?>
        </a>
      </td>
    </tr>
  <?php endforeach; ?>
</table>
<?php $content=ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
