<?php require __DIR__.'/_guard.php'; $pdo=db();
$id=(int)($_GET['id']??0);
$st=$pdo->prepare('SELECT * FROM tickets WHERE id=?'); $st->execute([$id]); $t=$st->fetch();
if(!$t){ http_response_code(404); die('Not found'); }
if($_SERVER['REQUEST_METHOD']==='POST'){
  $msg=trim($_POST['message']??'');
  if(strlen($msg)>=2){
    $u=current_user();
    $pdo->prepare('INSERT INTO ticket_replies (ticket_id,user_id,message) VALUES (?,?,?)')->execute([$id,$u['id'],$msg]);
  }
}
$re=$pdo->prepare('SELECT tr.*, u.username FROM ticket_replies tr JOIN users u ON u.id=tr.user_id WHERE ticket_id=? ORDER BY tr.id ASC');
$re->execute([$id]); $replies=$re->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-3">Ticket #<?= (int)$t['id'] ?> — <?= e($t['subject']) ?></h1>
<form method="post" class="rounded-2xl border p-3 space-y-3">
  <textarea name="message" class="w-full border p-2 rounded" placeholder="Admin reply"></textarea>
  <button class="px-4 py-2 rounded-xl bg-slate-900 text-white">Send</button>
</form>
<div class="mt-4 space-y-2">
  <?php foreach($replies as $r): ?>
    <div class="p-2 rounded border">
      <div class="text-xs opacity-70"><?= e($r['username']) ?> • <?= e($r['created_at']) ?></div>
      <div><?= e($r['message']) ?></div>
    </div>
  <?php endforeach; ?>
</div>
<?php $content=ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
