<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/csrf.php';

$error = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $username = trim($_POST['username']??'');
  $pass = $_POST['password']??'';
  $pdo = db();
  $st = $pdo->prepare('SELECT * FROM users WHERE username=?');
  $st->execute([$username]);
  $u = $st->fetch();
  if ($u && password_verify($pass, $u['pass_hash'])) {
    $_SESSION['uid'] = $u['id'];
    redirect('/index.php');
  } else {
    $error = 'Invalid credentials';
  }
}
ob_start(); ?>
<div class="max-w-md mx-auto">
  <h1 class="text-2xl font-bold mb-4">Login</h1>
  <?php if($error): ?><div class="mb-3 text-red-600"><?= e($error) ?></div><?php endif; ?>
  <form method="post" class="space-y-3 rounded-xl border p-4">
    <?php csrf_field(); ?>
    <input name="username" placeholder="Username" class="w-full p-2 rounded border" required>
    <input type="password" name="password" placeholder="Password" class="w-full p-2 rounded border" required>
    <button class="px-4 py-2 rounded-xl bg-slate-900 text-white w-full">Login</button>
    <div class="text-sm opacity-70">No account? <a class="underline" href="/register.php">Register</a></div>
  </form>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
