<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/auth.php';
require_login();
$pdo = db();
$id = (int)($_GET['id'] ?? 0);
if ($id) {
  $st = $pdo->prepare('SELECT o.*, p.title FROM orders o JOIN products p ON p.id=o.product_id WHERE o.id=? AND o.user_id=?');
  $st->execute([$id, $_SESSION['uid']]);
  $o = $st->fetch();
  if (!$o){ http_response_code(404); die('Order not found'); }
  ob_start(); ?>
  <h1 class="text-2xl font-bold mb-3">Order #<?= (int)$o['id'] ?> — <?= e($o['title']) ?></h1>
  <div class="rounded-2xl border p-4 bg-white/50 dark:bg-slate-800/50 space-y-3">
    <div>Amount: ₹ <b><?= e(cents($o['amount_cents'])) ?></b></div>
    <div>Purchased: <?= e($o['created_at']) ?></div>
    <div class="mt-4">
      <div class="font-semibold mb-1">Delivery Content:</div>
      <pre class="p-3 rounded-xl bg-slate-900 text-white overflow-auto"><?= e($o['delivered_text']) ?></pre>
    </div>
  </div>
  <?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
  <?php exit; }
$st = $pdo->prepare('SELECT o.*, p.title FROM orders o JOIN products p ON p.id=o.product_id WHERE o.user_id=? ORDER BY o.id DESC');
$st->execute([$_SESSION['uid']]);
$rows = $st->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Your Orders</h1>
<div class="space-y-3">
<?php foreach($rows as $o): ?>
  <a href="/orders.php?id=<?= (int)$o['id'] ?>" class="block rounded-2xl border p-4 hover:bg-slate-50 dark:hover:bg-slate-800/50">
    <div class="font-semibold"><?= e($o['title']) ?></div>
    <div class="text-sm opacity-70">#<?= (int)$o['id'] ?> • ₹ <?= e(cents($o['amount_cents'])) ?> • <?= e($o['created_at']) ?></div>
  </a>
<?php endforeach; ?>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
