<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';

$pdo = db();
$brand = trim($_GET['brand'] ?? '');
$country = trim($_GET['country'] ?? '');
$q = 'SELECT * FROM products WHERE is_active=1';
$params = [];
if ($brand !== '') { $q.=' AND brand=?'; $params[]=$brand; }
if ($country !== '') { $q.=' AND country=?'; $params[]=$country; }
$q.=' ORDER BY id DESC';
$st = $pdo->prepare($q);
$st->execute($params);
$rows = $st->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Products</h1>
<form class="flex gap-3 mb-4">
  <input class="border p-2 rounded" name="brand" placeholder="Brand/Type (e.g., Key, Book)" value="<?= e($brand) ?>">
  <input class="border p-2 rounded" name="country" placeholder="Country (optional)" value="<?= e($country) ?>">
  <button class="px-4 py-2 rounded-xl border">Filter</button>
</form>
<div class="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
  <?php foreach($rows as $p): ?>
    <div class="rounded-2xl border p-4 bg-white/50 dark:bg-slate-800/50">
      <div class="text-lg font-semibold mb-2"><?= e($p['title']) ?></div>
      <div class="text-sm opacity-70 mb-2">Type: <?= e($p['brand'] ?: '—') ?> • Country: <?= e($p['country'] ?: '—') ?></div>
      <div class="font-bold text-xl mb-3">₹ <?= e(cents($p['price_cents'])) ?></div>
      <div class="text-sm mb-3 opacity-70">Stock: <?= e($p['stock']) ?></div>
      <form method="post" action="/purchase.php" class="flex gap-2">
        <input type="hidden" name="product_id" value="<?= (int)$p['id'] ?>">
        <button class="px-3 py-2 rounded-xl bg-slate-900 text-white">Buy</button>
      </form>
    </div>
  <?php endforeach; ?>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
