<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/auth.php';
require_login();

$pid = (int)($_POST['product_id'] ?? 0);
$pdo = db();
$pdo->beginTransaction();
try {
  $st = $pdo->prepare('SELECT * FROM products WHERE id=? AND is_active=1 FOR UPDATE');
  $st->execute([$pid]);
  $p = $st->fetch();
  if (!$p || $p['stock'] < 1) throw new Exception('Out of stock');
  $st = $pdo->prepare('SELECT balance_cents FROM users WHERE id=? FOR UPDATE');
  $st->execute([$_SESSION['uid']]);
  $u = $st->fetch();
  if ($u['balance_cents'] < $p['price_cents']) throw new Exception('Insufficient balance');
  // deduct
  $st = $pdo->prepare('UPDATE users SET balance_cents=balance_cents-? WHERE id=?');
  $st->execute([$p['price_cents'], $_SESSION['uid']]);
  // reduce stock
  $st = $pdo->prepare('UPDATE products SET stock=stock-1 WHERE id=?');
  $st->execute([$pid]);
  // create order
  $st = $pdo->prepare('INSERT INTO orders (user_id, product_id, qty, amount_cents, delivered_text) VALUES (?,?,?,?,?)');
  $st->execute([$_SESSION['uid'],$pid,1,$p['price_cents'],$p['delivery_text']]);
  $oid = $pdo->lastInsertId();
  $pdo->commit();
  redirect('/orders.php?id='.$oid);
} catch(Throwable $e) {
  $pdo->rollBack();
  http_response_code(400);
  echo 'Error: '.$e->getMessage();
}
