<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/csrf.php';

$error = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $username = trim($_POST['username']??'');
  $email = trim($_POST['email']??'');
  $pass = $_POST['password']??'';
  if (!preg_match('/^[a-zA-Z0-9_]{3,32}$/', $username)) $error='Invalid username';
  if (!$error && !filter_var($email, FILTER_VALIDATE_EMAIL)) $error='Invalid email';
  if (!$error && strlen($pass)<6) $error='Password too short';
  if (!$error) {
    $pdo = db();
    try {
      $st = $pdo->prepare('INSERT INTO users (username,email,pass_hash) VALUES (?,?,?)');
      $st->execute([$username,$email,password_hash($pass, PASSWORD_BCRYPT)]);
      $_SESSION['uid'] = $pdo->lastInsertId();
      redirect('/index.php');
    } catch (Throwable $e) {
      $error = 'Username or email already in use';
    }
  }
}
ob_start(); ?>
<div class="max-w-md mx-auto">
  <h1 class="text-2xl font-bold mb-4">Create Account</h1>
  <?php if($error): ?><div class="mb-3 text-red-600"><?= e($error) ?></div><?php endif; ?>
  <form method="post" class="space-y-3 rounded-xl border p-4">
    <?php csrf_field(); ?>
    <input name="username" placeholder="Username" class="w-full p-2 rounded border" required>
    <input name="email" type="email" placeholder="Email" class="w-full p-2 rounded border" required>
    <input type="password" name="password" placeholder="Password" class="w-full p-2 rounded border" required>
    <button class="px-4 py-2 rounded-xl bg-emerald-600 text-white w-full">Register</button>
  </form>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
