<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/auth.php';
require_login();
$pdo = db();
$id=(int)($_GET['id']??0);
$st=$pdo->prepare('SELECT * FROM tickets WHERE id=? AND user_id=?');
$st->execute([$id,$_SESSION['uid']]);
$t=$st->fetch();
if(!$t){ http_response_code(404); die('Not found'); }
if($_SERVER['REQUEST_METHOD']==='POST'){
  $msg=trim($_POST['message']??'');
  if(strlen($msg)>=2){
    $r=$pdo->prepare('INSERT INTO ticket_replies (ticket_id,user_id,message) VALUES (?,?,?)');
    $r->execute([$id,$_SESSION['uid'],$msg]);
  }
}
$re=$pdo->prepare('SELECT tr.*, u.username FROM ticket_replies tr JOIN users u ON u.id=tr.user_id WHERE ticket_id=? ORDER BY tr.id ASC');
$re->execute([$id]);
$replies=$re->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Ticket #<?= (int)$t['id'] ?> — <?= e($t['subject']) ?></h1>
<div class="space-y-3 mb-4">
  <div class="p-3 rounded-xl border bg-white/50 dark:bg-slate-800/50"><?= e($t['message']) ?></div>
  <?php foreach($replies as $r): ?>
    <div class="p-3 rounded-xl border">
      <div class="text-xs opacity-70 mb-1"><?= e($r['username']) ?> • <?= e($r['created_at']) ?></div>
      <div><?= e($r['message']) ?></div>
    </div>
  <?php endforeach; ?>
</div>
<form method="post" class="rounded-2xl border p-3 space-y-3">
  <textarea name="message" class="w-full border p-2 rounded" placeholder="Reply"></textarea>
  <button class="px-4 py-2 rounded-xl bg-slate-900 text-white">Send</button>
</form>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
