<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/auth.php';
require_login();
$pdo = db();
$err='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $sub = trim($_POST['subject']??'');
  $msg = trim($_POST['message']??'');
  if (strlen($sub)<3 || strlen($msg)<5) $err='Subject or message too short';
  if (!$err){
    $st=$pdo->prepare('INSERT INTO tickets (user_id, subject, message) VALUES (?,?,?)');
    $st->execute([$_SESSION['uid'],$sub,$msg]);
  }
}
$st=$pdo->prepare('SELECT * FROM tickets WHERE user_id=? ORDER BY id DESC');
$st->execute([$_SESSION['uid']]);
$rows=$st->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Support</h1>
<form method="post" class="rounded-2xl border p-4 space-y-3 mb-4">
  <input class="border p-2 rounded w-full" name="subject" placeholder="Subject">
  <textarea class="border p-2 rounded w-full" name="message" placeholder="Message"></textarea>
  <button class="px-4 py-2 rounded-xl bg-slate-900 text-white">Create Ticket</button>
  <?php if($err): ?><div class="text-red-600"><?= e($err) ?></div><?php endif; ?>
</form>
<div class="space-y-2 text-sm">
  <?php foreach($rows as $t): ?>
    <a href="/ticket.php?id=<?= (int)$t['id'] ?>" class="block p-3 rounded border hover:bg-slate-50 dark:hover:bg-slate-800/50">
      #<?= (int)$t['id'] ?> • <?= e($t['subject']) ?> • <?= e($t['status']) ?>
    </a>
  <?php endforeach; ?>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
