<?php
session_start();
require_once __DIR__.'/../app/util.php';
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/auth.php';
require_login();
$pdo = db();
$u = $pdo->prepare('SELECT * FROM users WHERE id=?');
$u->execute([$_SESSION['uid']]);
$user=$u->fetch();
$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $amt = (int)round(floatval($_POST['amount']??'0')*100);
  $method = trim($_POST['method']??'manual');
  if ($amt<1000) $err='Minimum ₹10.00';
  if (!$err) {
    $st=$pdo->prepare('INSERT INTO deposits (user_id, method, amount_cents, status, reference) VALUES (?,?,?,?,?)');
    $st->execute([$_SESSION['uid'],$method,$amt,'pending',$_POST['reference']??'']);
    $ok='Deposit request created. Awaiting approval.';
  }
}
$st=$pdo->prepare('SELECT * FROM deposits WHERE user_id=? ORDER BY id DESC');
$st->execute([$_SESSION['uid']]);
$deps=$st->fetchAll();
ob_start(); ?>
<h1 class="text-2xl font-bold mb-4">Wallet</h1>
<div class="mb-4">Balance: <span class="font-bold">₹ <?= e(cents($user['balance_cents'])) ?></span></div>
<div class="grid md:grid-cols-2 gap-6">
  <div class="rounded-2xl border p-4">
    <h2 class="font-semibold mb-3">Add Funds</h2>
    <?php if(!empty($err)): ?><div class="text-red-600 mb-2"><?= e($err) ?></div><?php endif; ?>
    <?php if(!empty($ok)): ?><div class="text-emerald-600 mb-2"><?= e($ok) ?></div><?php endif; ?>
    <form method="post" class="space-y-3">
      <input class="border p-2 rounded w-full" name="amount" placeholder="Amount (₹)" required>
      <select class="border p-2 rounded w-full" name="method">
        <option value="manual">Manual Transfer (Admin Confirm)</option>
        <option value="mock">Mock Gateway (Webhook)</option>
      </select>
      <input class="border p-2 rounded w-full" name="reference" placeholder="Reference / UTR (optional)">
      <button class="px-4 py-2 rounded-xl bg-emerald-600 text-white w-full">Create Request</button>
    </form>
  </div>
  <div class="rounded-2xl border p-4">
    <h2 class="font-semibold mb-3">Recent Deposits</h2>
    <div class="space-y-2 text-sm">
      <?php foreach($deps as $d): ?>
        <div class="p-2 rounded border flex justify-between">
          <div>#<?= (int)$d['id'] ?> • <?= e($d['method']) ?> • ₹ <?= e(cents($d['amount_cents'])) ?></div>
          <div class="font-semibold <?= $d['status']==='approved'?'text-emerald-600':($d['status']==='rejected'?'text-red-600':'') ?>"><?= e($d['status']) ?></div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
<?php $content = ob_get_clean(); include __DIR__.'/../views/layout.php'; ?>
