<?php
$cfg = require __DIR__.'/../config.php';
?><!doctype html>
<html lang="en" class="h-full">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= e($cfg['app']['name']) ?></title>
<script src="https://cdn.tailwindcss.com"></script>
<script>
  try{
    const pref = localStorage.getItem('theme') || 'dark';
    if (pref === 'dark') document.documentElement.classList.add('dark');
  }catch(e){}
</script>
</head>
<body class="h-full bg-slate-50 dark:bg-slate-900 text-slate-900 dark:text-slate-100">
  <header class="border-b border-slate-200/20 bg-white/70 dark:bg-slate-800/50 backdrop-blur sticky top-0 z-10">
    <div class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
      <a href="/index.php" class="font-bold text-xl">💠 <?= e($cfg['app']['name']) ?></a>
      <nav class="flex gap-4 items-center text-sm">
        <a class="hover:underline" href="/products.php">Products</a>
        <a class="hover:underline" href="/orders.php">Orders</a>
        <a class="hover:underline" href="/wallet.php">Wallet</a>
        <a class="hover:underline" href="/tickets.php">Support</a>
        <?php if(isset($_SESSION['uid'])): ?>
          <a class="px-3 py-1 rounded-xl bg-emerald-600 text-white" href="/logout.php">Logout</a>
        <?php else: ?>
          <a class="px-3 py-1 rounded-xl bg-slate-900 text-white" href="/login.php">Login</a>
        <?php endif; ?>
        <button id="theme" class="px-3 py-1 rounded-xl border">🌓</button>
      </nav>
    </div>
  </header>
  <main class="max-w-6xl mx-auto px-4 py-6">
    <?= $content ?>
  </main>
  <script>
    document.getElementById('theme').addEventListener('click',()=>{
      document.documentElement.classList.toggle('dark');
      localStorage.setItem('theme', document.documentElement.classList.contains('dark')?'dark':'light');
    });
  </script>
</body>
</html>
