# Telegram PayIN Bot (PHP)

A minimal PHP Telegram bot that generates PayIN payment links with `/pay <amount>`, sends the link to the user, and notifies on success. 
Includes:
- Telegram webhook handler
- PayIN order creation and status checks
- Webhook endpoint to receive payment notifications (validated via Status API)
- Thank-you page that also checks live status
- CRON script to auto-update pending orders

## 1) Requirements
- PHP 8.1+ with cURL and PDO SQLite
- HTTPS domain
- A Telegram bot token from @BotFather
- PayIN creds: `MERCH_ID`, `SECRET_KEY`

## 2) Setup
1. Upload the folder to your server, e.g. `/var/www/telegram-payin-bot-php`.
2. Copy `.env.example` to `.env` and fill values.
3. Ensure `storage/` is writable by the webserver.
4. Create a public URL for:
   - Telegram webhook: `https://your-domain.com/public/index.php`
   - PayIN webhook: `https://your-domain.com/public/payin_webhook.php`
   - Thank-you page auto-used in redirect: `https://your-domain.com/public/thankyou.php?order_id=...`

5. Set the Telegram webhook (replace TOKEN and URL):
```
curl -X POST "https://api.telegram.org/botTOKEN/setWebhook"   -H "Content-Type: application/json"   -d '{"url":"https://your-domain.com/public/index.php"}'
```

## 3) Commands
- `/start` — basic help
- `/pay <amount>` — create an order and receive a payment link
- `/stats` — summary (restricted to ADMIN_CHAT_IDS)

## 4) CRON (auto status update)
Run every 2 minutes:
```
*/2 * * * * /usr/bin/php /path/to/telegram-payin-bot-php/cron/check_pending.php >> /path/to/telegram-payin-bot-php/storage/logs/cron.log 2>&1
```

## 5) Security Notes
- We validate PayIN webhooks by calling the Status API before marking SUCCESS.
- Keep `.env` secret. NEVER commit real keys.
- Use HTTPS and keep PHP updated.

## 6) File Map
- `public/index.php` — Telegram webhook (handles `/pay`)
- `public/payin_webhook.php` — PayIN webhook receiver
- `public/thankyou.php` — thank-you/status page
- `cron/check_pending.php` — periodic status checker
- `app/*` — config/bootstrap/helpers
- `storage/database/app.sqlite` — SQLite DB file (auto-created)
- `storage/logs/*` — logs

## 7) PayIN API conformity
- `X-VERIFY` computed as `hash_hmac('sha256', dataString, secret_key)` where `dataString` is `key=value|...` sorted by key.
- Order creation -> expects a `payment_url` in `result`.
- Status checks -> read `txnStatus` (SUCCESS/PENDING).

## 8) Customization
- Save real `customer_mobile` if you collect it in Telegram before creating orders.
- Change DB to MySQL by replacing the PDO DSN in `app/bootstrap.php`.
