<?php
require __DIR__ . '/../app/bootstrap.php';

// Check PENDING orders and update their status
$rows = $pdo->query("SELECT * FROM orders WHERE status='PENDING' ORDER BY id DESC LIMIT 200")->fetchAll(PDO::FETCH_ASSOC);

foreach ($rows as $order) {
    $payload = [
        'order_id' => $order['order_id'],
        'merch_id' => $config['payin']['merch_id'],
    ];
    $xverify = payin_xverify($payload, $config['payin']['secret_key']);
    [$status, $resp] = http_post_json($config['payin']['status_url'], $payload, ['X-VERIFY: ' . $xverify]);
    if ($status === false) {
        continue;
    }
    $data = json_decode($resp, true);
    if (($data['status'] ?? false) && isset($data['result']['txnStatus'])) {
        $txn = $data['result']['txnStatus'];
        if ($txn !== $order['status']) {
            $upd = $pdo->prepare("UPDATE orders SET status=?, updated_at=? WHERE id=?");
            $upd->execute([$txn, time(), $order['id']]);
            if ($txn === 'SUCCESS') {
                tg_api('sendMessage', [
                    'chat_id' => $order['chat_id'],
                    'text' => "✅ Payment Success!\nOrder: {$order['order_id']}\nAmount: {$order['amount']} {$order['currency']}",
                ]);
            }
        }
    }
}

echo "Checked " . count($rows) . " orders\n";
