<?php
require __DIR__ . '/../app/bootstrap.php';

// Read Telegram update
$raw = file_get_contents('php://input');
$update = json_decode($raw, true) ?? [];

if (!$update) {
    respond_json(['ok' => true, 'message' => 'No update']);
}

// Determine message or command
$message = $update['message'] ?? $update['edited_message'] ?? null;
$chat_id = $message['chat']['id'] ?? null;
$text = trim($message['text'] ?? '');

// Commands: /start, /pay <amount>, /stats
if ($text === '/start') {
    tg_api('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "Welcome! Use /pay <amount> to generate a payment link. Example:\n/pay 149",
        'parse_mode' => 'HTML'
    ]);
    respond_json(['ok' => true]);
}

if (preg_match('/^\/pay\s+(\d+)/', $text, $m)) {
    $amount = (int)$m[1];
    if ($amount < 1) {
        tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => "Amount must be >= 1"]);
        respond_json(['ok' => true]);
    }

    $order_id = 'ORD' . now() . rand(100, 999); // ensure high uniqueness
    $redirect_url = $config['app_url'] . '/public/thankyou.php?order_id=' . urlencode($order_id);

    $payload = [
        'customer_mobile' => '9999999999',
        'merch_id' => $config['payin']['merch_id'],
        'amount' => $amount,
        'order_id' => $order_id,
        'currency' => $config['payin']['currency'],
        'redirect_url' => $redirect_url,
        'udf1' => (string)$chat_id,
        'udf2' => 'Telegram',
        'udf3' => 'BotPay',
        'udf4' => '',
        'udf5' => '',
    ];

    $xverify = payin_xverify($payload, $config['payin']['secret_key']);
    [$status, $resp] = http_post_json($config['payin']['create_url'], $payload, ['X-VERIFY: ' . $xverify]);

    if ($status === false) {
        tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => "Network error creating order: {$resp}"]);
        respond_json(['ok' => true]);
    }

    $data = json_decode($resp, true);
    if (!isset($data['status']) || !$data['status']) {
        $msg = $data['message'] ?? 'Unknown error';
        tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => "Failed to create order: {$msg}"]);
        respond_json(['ok' => true]);
    }

    $payment_url = $data['result']['payment_url'] ?? null;
    if (!$payment_url) {
        tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => "API did not return payment_url."]);
        respond_json(['ok' => true]);
    }

    // Save order
    $stmt = $pdo->prepare("INSERT INTO orders (chat_id, amount, order_id, payment_url, status, created_at, updated_at, currency) VALUES (?, ?, ?, ?, 'PENDING', ?, ?, ?)");
    $stmt->execute([$chat_id, $amount, $order_id, $payment_url, now(), now(), $config['payin']['currency']]);

    $msg = "✅ Order Created\n"
         . "Order ID: <code>{$order_id}</code>\n"
         . "Amount: {$amount} {$config['payin']['currency']}\n"
         . "Pay here: {$payment_url}\n\n"
         . "After payment, you'll receive an automatic confirmation.";
    tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'parse_mode' => 'HTML']);

    respond_json(['ok' => true]);
}

if (preg_match('/^\/stats$/', $text)) {
    if (!in_array((string)$chat_id, $config['admin_chat_ids'])) {
        tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => "Unauthorized"]);
        respond_json(['ok' => true]);
    }
    $row = $pdo->query("SELECT 
        SUM(CASE WHEN status='SUCCESS' THEN amount ELSE 0 END) as total_success,
        SUM(CASE WHEN status='PENDING' THEN 1 ELSE 0 END) as pending_count,
        COUNT(*) as total_orders
    FROM orders")->fetch(PDO::FETCH_ASSOC);
    $report = "Total orders: {$row['total_orders']}\n"
            . "Pending: {$row['pending_count']}\n"
            . "Total Success Amount: {$row['total_success']}";
    tg_api('sendMessage', ['chat_id' => $chat_id, 'text' => $report]);
    respond_json(['ok' => true]);
}

// Fallback
respond_json(['ok' => true]);
