<?php
// Simple config + env loader

function env($key, $default = null) {
    static $loaded = false;
    static $vars = [];
    if (!$loaded) {
        $envFile = __DIR__ . '/../.env';
        if (file_exists($envFile)) {
            $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                if (str_starts_with(trim($line), '#')) continue;
                if (!str_contains($line, '=')) continue;
                [$k, $v] = array_map('trim', explode('=', $line, 2));
                $vars[$k] = $v;
            }
        }
        $loaded = true;
    }
    return $vars[$key] ?? getenv($key) ?? $default;
}

return [
    'bot_token' => env('BOT_TOKEN', ''),
    'bot_username' => env('BOT_USERNAME', ''),
    'app_url' => rtrim(env('APP_URL', ''), '/'),
    'payin' => [
        'create_url' => 'https://sztgbots.online/api/v1/order',
        'status_url'  => 'https://sztgbots.online/api/v1/status',
        'merch_id' => env('MERCH_ID', ''),
        'secret_key' => env('SECRET_KEY', ''),
        'currency' => 'INR',
    ],
    'db' => [
        'path' => __DIR__ . '/../' . env('DB_PATH', 'storage/database/app.sqlite'),
    ],
    'admin_chat_ids' => array_filter(array_map('trim', explode(',', env('ADMIN_CHAT_IDS', '')))),
];
