<?php
require __DIR__ . '/../app/bootstrap.php';

$order_id = $_GET['order_id'] ?? '';

$statement = $pdo->prepare("SELECT * FROM orders WHERE order_id = ?");
$statement->execute([$order_id]);
$order = $statement->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    http_response_code(404);
    echo "Order not found";
    exit;
}

// Auto-check status to show latest info
$payload = [
    'order_id' => $order['order_id'],
    'merch_id' => $config['payin']['merch_id'],
];
$xverify = payin_xverify($payload, $config['payin']['secret_key']);
[$status, $resp] = http_post_json($config['payin']['status_url'], $payload, ['X-VERIFY: ' . $xverify]);
$txnStatus = $order['status'];
if ($status !== false) {
    $data = json_decode($resp, true);
    if (($data['status'] ?? false) && isset($data['result']['txnStatus'])) {
        $txnStatus = $data['result']['txnStatus'];
        if ($txnStatus !== $order['status']) {
            $upd = $pdo->prepare("UPDATE orders SET status=?, updated_at=? WHERE order_id=?");
            $upd->execute([$txnStatus, time(), $order['order_id']]);
        }
    }
}

?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Thank You</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: system-ui, -apple-system, Segoe UI, Roboto, sans-serif; margin: 2rem; }
    .card { max-width: 600px; margin: auto; padding: 1.5rem; border: 1px solid #eee; border-radius: 14px; box-shadow: 0 6px 16px rgba(0,0,0,0.06); }
    .status { font-weight: 700; }
    .success { color: #0a8f28; }
    .pending { color: #c98200; }
    .failed { color: #b00020; }
    a.btn { display: inline-block; padding: .6rem 1rem; border-radius: 10px; border: 1px solid #ccc; text-decoration: none; }
  </style>
</head>
<body>
  <div class="card">
    <h2>Thank you!</h2>
    <p>Order ID: <strong><?=htmlspecialchars($order['order_id'])?></strong></p>
    <p>Amount: <strong><?=htmlspecialchars($order['amount'])?> <?=htmlspecialchars($order['currency'])?></strong></p>
    <p class="status <?=strtolower(htmlspecialchars($txnStatus))?>">Current status: <?=htmlspecialchars($txnStatus)?></p>
    <?php if ($txnStatus !== 'SUCCESS'): ?>
      <p><a class="btn" href="<?=htmlspecialchars($order['payment_url'])?>">Try payment again</a></p>
    <?php else: ?>
      <p>Your payment is confirmed. You can close this page.</p>
    <?php endif; ?>
  </div>
</body>
</html>
