<?php
require __DIR__ . '/../app/bootstrap.php';

/*
Webhook fields (POST):
status, order_id, customer_mobile, amount, currency_code, udf1..udf5, time

We will verify by calling the status API to prevent spoofing.
*/

$post = $_POST;
$order_id = $post['order_id'] ?? null;
$claimed_status = $post['status'] ?? null;

if (!$order_id) {
    http_response_code(400);
    echo "order_id required";
    exit;
}

// Fetch order
$stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id = ?");
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    http_response_code(404);
    echo "Unknown order";
    exit;
}

// Confirm via Status API
$payload = [
    'order_id' => $order_id,
    'merch_id' => $config['payin']['merch_id'],
];
$xverify = payin_xverify($payload, $config['payin']['secret_key']);
[$status_code, $resp] = http_post_json($config['payin']['status_url'], $payload, ['X-VERIFY: ' . $xverify]);

$valid_success = false;
if ($status_code !== false) {
    $data = json_decode($resp, true);
    if (($data['status'] ?? false) && ($data['result']['txnStatus'] ?? '') === 'SUCCESS') {
        $valid_success = true;
    }
}

$new_status = $valid_success ? 'SUCCESS' : ($claimed_status ?: 'PENDING');

if ($new_status !== $order['status']) {
    $upd = $pdo->prepare("UPDATE orders SET status=?, updated_at=? WHERE order_id=?");
    $upd->execute([$new_status, time(), $order_id]);
}

// Notify user on success
if ($new_status === 'SUCCESS') {
    tg_api('sendMessage', [
        'chat_id' => $order['chat_id'],
        'text' => "🎉 Payment received!\nOrder: {$order['order_id']}\nAmount: {$order['amount']} {$order['currency']}",
    ]);
}

echo "OK";
