# Telegram Paid Giveaway Bot (PHP) - Full Package

This package contains a ready-to-deploy Telegram paid-giveaway bot implemented in PHP.
Before running, open `config.php` and set your values (BOT token, DB credentials, LG Pay keys, WEBHOOK URL).

Files included:
- schema.sql                -> Database schema
- config.php                -> Set your secrets here
- db.php                    -> PDO connection (utf8mb4)
- helpers.php               -> All helper functions (LG Pay, UI, progress bar)
- webhook.php               -> Telegram webhook handler
- payment_callback.php      -> LG Pay callback endpoint
- admin_panel.php           -> Simple admin web UI (protected by ?pw=ADMIN_PASSWORD)
- test_list.php             -> Debug script to view giveaways table quickly

Deployment steps:
1. Create MySQL database and run `schema.sql`.
2. Update `config.php` with real values.
3. Upload files to HTTPS-enabled server.
4. Set Telegram webhook: `https://api.telegram.org/bot<YOUR_BOT_TOKEN>/setWebhook?url=https://yourdomain.com/webhook.php`
5. Set LG Pay notify URL to `LG_PAY_NOTIFY_URL` in LG Pay dashboard.
6. Create admin via `/admin <ADMIN_PASSWORD>` or insert into DB, then create giveaways via `/create_giveaway` or admin panel.

Important:
- Ensure DB charset uses utf8mb4. `db.php` connects with charset utf8mb4 and runs `SET NAMES utf8mb4`.
- Do not commit secrets to public repos.
- Test thoroughly in LG Pay sandbox before going live.

If you want, I can update this ZIP to include S3 image upload or stronger admin login.
