<?php
// admin_panel.php - simple admin UI (protected by ?pw=ADMIN_PASSWORD)
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/config.php';

if (!isset($_GET['pw']) || $_GET['pw'] !== ADMIN_PASSWORD) {
    echo 'Auth required: append ?pw=' . ADMIN_PASSWORD . ' to URL';
    exit;
}

$pdo = getPDO();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create'])) {
    $title = $_POST['title'] ?? '';
    $price = floatval($_POST['price'] ?? 0);
    $slots = intval($_POST['slots'] ?? 1);
    $prize = $_POST['prize'] ?? '';
    $image = $_POST['image_url'] ?? '';
    $desc = $_POST['desc'] ?? '';

    $stmt = $pdo->prepare("INSERT INTO giveaways (title,description,prize,image_url,price,total_slots,joined_count,is_active) VALUES (?,?,?,?,?,?,0,1)");
    $stmt->execute([trim($title), trim($desc), trim($prize), trim($image), $price, $slots]);
    $created_msg = 'Created giveaway';
}

$g = $pdo->query("SELECT * FROM giveaways ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Admin Panel</title>
<style>body{font-family:system-ui,Arial;padding:20px;background:#f5f7fb} .card{background:#fff;padding:12px;border-radius:8px;box-shadow:0 2px 6px rgba(0,0,0,0.06);margin-bottom:12px} input,textarea{width:100%;padding:8px;margin:6px 0;border:1px solid #ddd;border-radius:6px} button{padding:10px 14px;border-radius:6px;border:0;background:#10b981;color:white}</style>
</head><body>
<h1>Admin Panel</h1>
<?php if(!empty($created_msg)): ?><div style="color:green;padding:8px;border-radius:6px;background:#e6fffa"><?=$created_msg?></div><?php endif; ?>
<div class="card">
  <h3>Create Giveaway</h3>
  <form method="post">
    <input name="title" placeholder="Title" required />
    <input name="price" placeholder="Entry Fee (eg. 499)" required />
    <input name="slots" placeholder="Total slots (eg. 100)" required />
    <input name="prize" placeholder="Prize (text)" />
    <input name="image_url" placeholder="Image URL (public)" />
    <textarea name="desc" placeholder="Description"></textarea>
    <button name="create">Create</button>
  </form>
</div>
<h2>Giveaways</h2>
<?php foreach($g as $row): ?>
<div class="card">
  <b>ID:</b> <?=$row['id']?> — <b><?=htmlspecialchars($row['title'])?></b><br>
  Price: ₹<?=number_format($row['price'],2)?>, Joined: <?=$row['joined_count']?> / <?=$row['total_slots']?>, Active: <?=$row['is_active']?><br>
  <small>Created: <?=$row['created_at']?></small>
</div>
<?php endforeach; ?>
</body></html>