<?php
// db.php - PDO connection using utf8mb4
require_once __DIR__ . '/config.php';

function getPDO(){
  static $pdo = null;
  if($pdo) return $pdo;

  $dsn = "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4";
  $options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ];

  $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
  // ensure connection uses utf8mb4
  $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
  return $pdo;
}
?>