<?php
// payment_callback.php - LG Pay webhook receiver
require_once __DIR__ . '/helpers.php';

$payload = $_POST ?: json_decode(file_get_contents('php://input'), true);
if (!$payload) { http_response_code(400); echo 'bad'; exit; }

$order_sn = $payload['order_sn'] ?? null;
$received_sign = $payload['sign'] ?? '';

if (!$order_sn) { http_response_code(400); echo 'missing order_sn'; exit; }

// verify sign - adjust if LG Pay uses different signature method
$check = $payload; unset($check['sign']);
$my_sign = lgpaySign($check);
if ($received_sign && $my_sign !== $received_sign) { http_response_code(400); echo 'invalid sign'; exit; }

$pdo = getPDO();
$stmt = $pdo->prepare("SELECT id, user_id, payment_payload, status FROM orders WHERE payment_payload LIKE ? LIMIT 1");
$stmt->execute(["%\"order_sn\":\"$order_sn\"%"]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$order) { http_response_code(404); echo 'order not found'; exit; }

$status = (string)($payload['status'] ?? '');
if ($status === '1' && $order['status'] !== 'paid') {
    $stmt = $pdo->prepare("UPDATE orders SET status='paid', payment_payload = ? WHERE id = ?");
    $stmt->execute([json_encode($payload), $order['id']]);
    verifyPaymentAndMarkPaid($order['id'], $payload);

    $chat_id = $order['user_id'];
    $msg = "💰 <b>Payment Received!</b>\n\nPlease reply with your contact details (phone/email) to confirm your entry.";
    sendMessage($chat_id, $msg);
    echo 'OK';
} else {
    echo 'ignored';
}
?>