<?php
require_once __DIR__ . '/db.php';
header('Content-Type: text/plain; charset=utf-8');
try {
  $pdo = getPDO();
  echo "Connected DB: " . DB_NAME . "\n\n";
  $r = $pdo->query("SELECT COUNT(*) AS c FROM giveaways")->fetch(PDO::FETCH_ASSOC);
  echo "Total giveaways: " . ($r['c'] ?? '0') . "\n\n";
  $stmt = $pdo->query("SELECT id,title,is_active,price,total_slots,joined_count,image_url,created_at FROM giveaways ORDER BY created_at DESC LIMIT 20");
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
  if(empty($rows)){ echo "No rows returned.\n"; } else {
    foreach($rows as $row){
      echo "ID: {$row['id']} | title: {$row['title']} | active: {$row['is_active']} | price: {$row['price']} | joined: {$row['joined_count']}/{$row['total_slots']}\n";
      echo "image_url: {$row['image_url']}\n";
      echo "created_at: {$row['created_at']}\n\n";
    }
  }
} catch (Exception $e) { echo 'ERROR: ' . $e->getMessage(); }
?>