<?php
// webhook.php - full, debug-friendly webhook
require_once __DIR__ . '/helpers.php';

$update = json_decode(file_get_contents('php://input'), true);
if (!$update) exit;

$pdo = getPDO();

if (isset($update['message'])) {
    $msg = $update['message'];
    $chat_id = $msg['chat']['id'];
    $user_id = $msg['from']['id'];

    try {
        $stmt = $pdo->prepare("INSERT IGNORE INTO users (id, username, first_name, last_name) VALUES (?, ?, ?, ?)");
        $stmt->execute([$user_id, $msg['from']['username'] ?? null, $msg['from']['first_name'] ?? null, $msg['from']['last_name'] ?? null]);
    } catch (Exception $e) {
        // continue
    }

    if (isset($msg['text'])) {
        $text = trim($msg['text']);

        // /start - debug friendly
        if (preg_match('/^\/start/i', $text)) {
            try {
                sendMessage($chat_id, "👋 Welcome! Here are active giveaways:");

                // direct fetch for debugging
                $stmt = $pdo->query("SELECT id,title,description,price,total_slots,joined_count,is_active,image_url FROM giveaways ORDER BY created_at DESC LIMIT 50");
                $giveaways = $stmt->fetchAll(PDO::FETCH_ASSOC);

                if (empty($giveaways)) {
                    sendMessage($chat_id, "⚠️ No giveaways found in DB. To create one, use the admin panel or run SQL.");
                    $count = $pdo->query("SELECT COUNT(*) AS c FROM giveaways")->fetch(PDO::FETCH_ASSOC);
                    sendMessage($chat_id, "🔎 Debug: giveaways count = " . ($count['c'] ?? '0') . " | DB: " . DB_NAME);
                    exit;
                }

                $active = array_filter($giveaways, function($g){ return intval($g['is_active'])===1; });
                if (empty($active)) {
                    sendMessage($chat_id, "⚠️ There are giveaways but none are active (is_active != 1). Activate with UPDATE giveaways SET is_active=1 WHERE id=<id>;");
                    $msgx = "Latest giveaways (up to 5):\n";
                    $i=0;
                    foreach($giveaways as $g){ if($i++>=5) break; $msgx .= "ID: {$g['id']} | title: {$g['title']} | active: {$g['is_active']} | price: {$g['price']}\n"; }
                    sendMessage($chat_id, $msgx);
                    exit;
                }

                foreach ($active as $g) {
                    $caption = giveawayCaption($g);
                    $keyboard = buildGiveawayKeyboard($g);
                    if (!empty($g['image_url'])) {
                        sendPhoto($chat_id, $g['image_url'], $caption, ['reply_markup'=>json_encode(['inline_keyboard'=>$keyboard])]);
                    } else {
                        sendInlineKeyboard($chat_id, $caption, $keyboard);
                    }
                }

            } catch (Exception $e) {
                sendMessage($chat_id, "❌ Error fetching giveaways: " . $e->getMessage());
            }
            exit;
        }

        // /admin
        if (preg_match('/^\/admin\s+(.+)$/i', $text, $m)) {
            $pw = trim($m[1]);
            if ($pw === ADMIN_PASSWORD) {
                $stmt = $pdo->prepare("INSERT IGNORE INTO admins (telegram_id, username) VALUES (?, ?)");
                $stmt->execute([$user_id, $msg['from']['username'] ?? null]);
                sendMessage($chat_id, "✅ You are now an admin. Use /create_giveaway Title|Price|Slots|Prize|ImageURL|Description");
            } else {
                sendMessage($chat_id, "❌ Invalid admin password.");
            }
            exit;
        }

        // /create_giveaway
        if (preg_match('/^\/create_giveaway\s+(.+)$/is', $text, $m)) {
            $check = $pdo->prepare("SELECT 1 FROM admins WHERE telegram_id = ?");
            $check->execute([$user_id]);
            if (!$check->fetch()) { sendMessage($chat_id, "❌ Only admins can create giveaways."); exit; }

            $parts = explode('|', trim($m[1]), 6);
            if (count($parts) < 3) { sendMessage($chat_id, "Usage: /create_giveaway Title|Price|Slots|Prize|ImageURL|Description"); exit; }
            [$title,$price,$slots,$prize,$image_url,$desc] = array_pad($parts,6,'');
            $stmt = $pdo->prepare("INSERT INTO giveaways (title,description,prize,image_url,price,total_slots,joined_count,is_active) VALUES (?,?,?,?,?,?,0,1)");
            $stmt->execute([trim($title), trim($desc), trim($prize), trim($image_url), floatval($price), intval($slots)]);
            sendMessage($chat_id, "✅ Giveaway created!");
            exit;
        }

        // contact reply after payment
        if (isset($msg['reply_to_message']) && strpos($msg['reply_to_message']['text'] ?? '', 'Please reply with your contact') !== false) {
            $stmt = $pdo->prepare("SELECT id FROM orders WHERE user_id = ? AND status = 'paid' AND (contact_info IS NULL OR contact_info = '') ORDER BY created_at DESC LIMIT 1");
            $stmt->execute([$user_id]);
            $o = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($o) { $stmt = $pdo->prepare("UPDATE orders SET contact_info = ? WHERE id = ?"); $stmt->execute([trim($msg['text']), $o['id']]); sendMessage($chat_id, "✅ Contact saved. Entry confirmed."); }
            else sendMessage($chat_id, "⚠️ No paid order found waiting for contact.");
            exit;
        }
    }

    if (isset($msg['contact'])) {
        $phone = $msg['contact']['phone_number'] ?? null;
        if ($phone) {
            $stmt = $pdo->prepare("SELECT id FROM orders WHERE user_id = ? AND status = 'paid' AND (contact_info IS NULL OR contact_info = '') ORDER BY created_at DESC LIMIT 1");
            $stmt->execute([$user_id]); $o = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($o) { $stmt = $pdo->prepare("UPDATE orders SET contact_info = ? WHERE id = ?"); $stmt->execute([$phone, $o['id']]); sendMessage($chat_id, "✅ Contact saved. Entry confirmed."); }
            else sendMessage($chat_id, "⚠️ No paid order waiting for contact.");
        } else sendMessage($chat_id, "⚠️ Contact missing phone number.");
        exit;
    }
}

// CALLBACKS
if (isset($update['callback_query'])) {
    $cb = $update['callback_query']; $data = $cb['data'] ?? ''; $chat_id = $cb['message']['chat']['id']; $user_id = $cb['from']['id']; $cbid = $cb['id'];

    if (strpos($data, 'details:') === 0) {
        $gid = intval(substr($data,8));
        $stmt = $pdo->prepare("SELECT * FROM giveaways WHERE id = ?"); $stmt->execute([$gid]); $g = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$g) { tgRequest('answerCallbackQuery', ['callback_query_id'=>$cbid,'text'=>'Giveaway not found.']); exit; }
        $full = "<b>".htmlspecialchars($g['title'])."</b>\n\n"; if(!empty($g['prize'])) $full .= "🎁 Prize: <b>".htmlspecialchars($g['prize'])."</b>\n"; $full .= "💵 Entry Fee: <b>₹".number_format($g['price'],2)."</b>\n"; $full .= "👥 Joined: <b>{$g['joined_count']}</b> / <b>{$g['total_slots']}</b>\n\n"; $full .= "📜 Description:\n" . ($g['description'] ?: 'No description provided.'); sendMessage($chat_id,$full); tgRequest('answerCallbackQuery', ['callback_query_id'=>$cbid,'text'=>'Details shown.']); exit;
    }

    if (strpos($data,'join:')===0) {
        $gid = intval(substr($data,5)); $stmt=$pdo->prepare("SELECT * FROM giveaways WHERE id=?"); $stmt->execute([$gid]); $g=$stmt->fetch(PDO::FETCH_ASSOC);
        if(!$g){ tgRequest('answerCallbackQuery', ['callback_query_id'=>$cbid,'text'=>'Not found']); exit; }
        if(intval($g['joined_count'])>=intval($g['total_slots'])){ tgRequest('answerCallbackQuery',['callback_query_id'=>$cbid,'text'=>'Sold out']); exit; }
        $res = startPayment($user_id,$gid,$g['price']); if(isset($res['error'])){ sendMessage($chat_id, '❌ '.$res['error']); tgRequest('answerCallbackQuery',['callback_query_id'=>$cbid,'text'=>'Error creating order']); exit; }
        if(!empty($res['payment_url'])){ $pay_url = $res['payment_url']; sendMessage($chat_id, "🔗 <b>Payment Link</b>\n\nClick to pay: <a href='{$pay_url}'>Pay ₹".number_format($g['price'],2)."</a>\n\nAfter payment reply with contact details."); tgRequest('answerCallbackQuery',['callback_query_id'=>$cbid,'text'=>'Payment link sent']); } else { sendMessage($chat_id,'❌ Failed to create payment link.'); tgRequest('answerCallbackQuery',['callback_query_id'=>$cbid,'text'=>'Payment failed']); }
        exit;
    }

    if (strpos($data,'soldout:')===0){ tgRequest('answerCallbackQuery',['callback_query_id'=>$cbid,'text'=>'This giveaway is sold out.']); exit; }
    if (strpos($data,'share:')===0){ $gid=intval(substr($data,6)); $stmt=$pdo->prepare("SELECT * FROM giveaways WHERE id=?"); $stmt->execute([$gid]); $g=$stmt->fetch(PDO::FETCH_ASSOC); if($g){ sendMessage($chat_id, giveawayCaption($g) . "\nJoin via /start"); } tgRequest('answerCallbackQuery',['callback_query_id'=>$cbid,'text'=>'Shareable card sent']); exit; }
}
?>