<?php
// ===== YOUR SETTINGS =====
// Get API_ID and API_HASH from https://my.telegram.org
const API_ID      = 1234567;                 
const API_HASH    = 'your_api_hash_here';    

// LG Pay credentials
const LG_APP_ID   = 'your_lg_app_id';
const LG_SECRET   = 'your_lg_secret_key';
const TRADE_TYPE  = 'test';                  

// Server public IP (LG docs require an IP); your server's public IP is fine
const PAYER_IP    = '203.0.113.10';

// Public HTTPS notify URL — must point to public notify.php with a secret
// Example: https://yourdomain.com/notify.php?secret=XYZ123
const NOTIFY_URL  = 'https://yourdomain.com/notify.php?secret=XYZ123';

// Session file path (keep in same folder by default)
const SESSION_FILE = __DIR__ . '/userbot.session';

// LG endpoints
const CREATE_URL  = 'https://www.lg-pay.com/api/order/create';
const QUERY_URL   = 'https://www.lg-pay.com/api/order/query';
const BAL_URL     = 'https://www.lg-pay.com/api/deposit/balance';

// Defaults
const DEFAULT_REMARK = 'telegram-pay';

// ===== Helpers (shared) =====
function md5_upper(string $s): string { return strtoupper(md5($s)); }

/**
 * LG signature: ASCII-sort non-empty params, append &key=SECRET, MD5 uppercase
 */
function lg_sign(array $params, string $secret): string {
    $clean = [];
    foreach ($params as $k => $v) {
        if ($k === 'sign') continue;
        if ($v === null) continue;
        $vs = (string)$v;
        if ($vs === '') continue;
        $clean[$k] = $vs;
    }
    ksort($clean, SORT_STRING);
    $pairs = [];
    foreach ($clean as $k => $v) { $pairs[] = $k.'='.$v; }
    $stringA = implode('&', $pairs);
    return md5_upper($stringA.'&key='.$secret);
}

function http_post_form(string $url, array $data, int $timeout = 20): array {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
        CURLOPT_POSTFIELDS => http_build_query($data),
    ]);
    $res = curl_exec($ch);
    if ($res === false) { $err = curl_error($ch); curl_close($ch); throw new RuntimeException('cURL error: '.$err); }
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE); curl_close($ch);
    if ($code < 200 || $code >= 300) { throw new RuntimeException('HTTP '.$code.': '.$res); }
    $j = json_decode($res, true);
    if (!is_array($j)) throw new RuntimeException('Invalid JSON: '.$res);
    return $j;
}

function make_order_sn(string $prefix = 'ORD'): string {
    return $prefix.(string)floor(microtime(true)*1000);
}
