<?php
require_once __DIR__.'/vendor/autoload.php';
require_once __DIR__.'/config.php';

use danog\MadelineProto\API;
use danog\MadelineProto\EventHandler;

// ===== API wrappers used ONLY by userbot =====
function lg_create_order(float $amountINR, ?string $remark = null): array {
    $order_sn = make_order_sn();
    $money_paise = (int) round($amountINR * 100);
    $payload = [
        'app_id'     => LG_APP_ID,
        'trade_type' => TRADE_TYPE,
        'order_sn'   => $order_sn,
        'money'      => $money_paise,
        'notify_url' => NOTIFY_URL,
        'ip'         => PAYER_IP,
        'remark'     => $remark ?: DEFAULT_REMARK,
    ];
    $payload['sign'] = lg_sign($payload, LG_SECRET);
    $resp = http_post_form(CREATE_URL, $payload);
    return [$order_sn, $resp];
}
function lg_query(string $order_sn): array {
    $payload = [ 'app_id' => LG_APP_ID, 'order_sn' => $order_sn ];
    $payload['sign'] = lg_sign($payload, LG_SECRET);
    return http_post_form(QUERY_URL, $payload);
}
function lg_balance(): array {
    $payload = [ 'app_id' => LG_APP_ID, 'time' => time() ];
    $payload['sign'] = lg_sign($payload, LG_SECRET);
    return http_post_form(BAL_URL, $payload);
}

class MyHandler extends EventHandler {
    public const REPORT_ERRORS = false;
    public function getReportPeers(): array { return []; }

    public function onUpdateNewMessage(array $update): void {
        $message = $update['message'] ?? null; if (!$message) return;
        if (empty($message['out'])) return; // only your outgoing messages
        $text = trim($message['message'] ?? ''); if ($text === '') return;
        $peer = $message['to_id'];

        // /pay <amount> [remark]
        if (str_starts_with($text, '/pay')) {
            $parts = preg_split('/\s+/', $text, 3);
            if (count($parts) < 2) { $this->messages->sendMessage(peer:$peer, message:"Usage: /pay <amount> [remark]"); return; }
            $amountStr = str_replace(',', '', $parts[1]);
            if (!is_numeric($amountStr) || (float)$amountStr <= 0) { $this->messages->sendMessage(peer:$peer, message:"Amount invalid. Example: /pay 299"); return; }
            $amount = (float)$amountStr; $remark = $parts[2] ?? DEFAULT_REMARK;
            try { [$order_sn, $res] = lg_create_order($amount, $remark); }
            catch (\Throwable $e) { $this->messages->sendMessage(peer:$peer, message:"❌ Create order error: ".$e->getMessage()); return; }
            $status = $res['status'] ?? 0; $data = $res['data'] ?? []; $payUrl = $data['pay_url'] ?? null;
            if ($status === 1 && ($data['type'] ?? '') === 'url' && $payUrl) {
                $txt = "🔔 Order Created\n🧾 Order: `{$order_sn}`\n💰 Amount: ₹".number_format($amount,2)."\n💬 Remark: {$remark}\n\n👉 Pay here: {$payUrl}";
                $this->messages->sendMessage(peer:$peer, message:$txt, parseMode:['_' => 'Markdown']);
            } else {
                $this->messages->sendMessage(peer:$peer, message:"❌ LG Pay create failed: ".json_encode($res, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE));
            }
            return;
        }

        // /check <order_sn>
        if (str_starts_with($text, '/check')) {
            $parts = preg_split('/\s+/', $text, 2); if (count($parts) < 2) { $this->messages->sendMessage(peer:$peer, message:"Usage: /check <order_sn>"); return; }
            $order = trim($parts[1]);
            try { $r = lg_query($order); } catch (\Throwable $e) { $this->messages->sendMessage(peer:$peer, message:"❌ Query error: ".$e->getMessage()); return; }
            $st = $r['status'] ?? null; $msg = $r['msg'] ?? ''; $money = isset($r['data']['money']) ? '₹'.number_format($r['data']['money']/100, 2) : '—';
            $this->messages->sendMessage(peer:$peer, message:"📦 Query `{$order}` → status={$st}, msg={$msg}\nMoney(拉单金额): {$money}", parseMode:['_' => 'Markdown']);
            return;
        }

        // /balance
        if ($text === '/balance') {
            try { $r = lg_balance(); } catch (\Throwable $e) { $this->messages->sendMessage(peer:$peer, message:"❌ Balance error: ".$e->getMessage()); return; }
            $st = $r['status'] ?? null; $bal = isset($r['data']['balance']) ? '₹'.number_format($r['data']['balance']/100, 2) : '—';
            $this->messages->sendMessage(peer:$peer, message:"🏦 Balance status={$st}\nBalance: {$bal}");
            return;
        }
    }
}

// Start userbot
$api = new API(SESSION_FILE);
$api->start(); // first run asks phone + OTP (+2FA)
$api->setEventHandler(MyHandler::class);
$api->loop();
